<?php
/**************************************************************************
 * Copyright 2004 Jeremy March
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * jeremy_march@comcast.net
 * http://sourceforge.net/projects/tree-factory/
 *
 **************************************************************************/

//error_reporting(E_ALL);
ob_start();

require_once "lib_example1.php";
require_once "TF_nested_sets.php";
$allTimeStart = get_microtime();

/************Config************************/

// Connection Parameters
define('USER',       'treeuser');
define('PASSWORD',   '1234');
define('HOST',       'localhost');
define('DATABASE',   'trees');

define('MY_ROUND',   4);

$db_conn = mysql_pconnect('localhost', 'root', '') or die("Did Not Connect");
mysql_select_db(trees, $db_conn) or die("Did Not Select Database");

// Tree Parameters
define('TABLE_TYPE',  'myisam');  // e.g. 'myisam', 'innodb', or 'none'
define('DEBUG',       TRUE);

$fields  = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('node'), 'display'=>'node', 'other'=>array('node'));
$fields2 = array('id'=>'id2', 'left'=>'lft2', 'right'=>'rgt2', 'orderby'=>array('node2'), 'display'=>'node2', 'other'=>array('node2'));
$fields3 = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('last','first'), 'display'=>'CONCAT(last, ", ", first)', 'other'=>array('last','first'));

$trees   = array();
$trees[] = new TF_ns_tree($db_conn, 'treefactory', TABLE_TYPE, $fields, DEBUG);
$trees[] = new TF_ns_tree($db_conn, 'treefactory2', TABLE_TYPE, $fields2, DEBUG);
$trees[] = new TF_ns_tree($db_conn, 'tfnames', TABLE_TYPE, $fields3, DEBUG);
//$trees[] = new TF_ns_tree($db_conn, 'tree1000', TABLE_TYPE, $fields, DEBUG);

/************End-Config************************/

$numTrees = count($trees);

// states for output section
define('STATE_NO_NODE'       , 1);
define('STATE_NEW_RECORD'    , 2);
define('STATE_VALID'         , 3);

define('SPACES_PER_TAB'      , 4);
define('PICS_PER_TAB'        , 40);
/**********************VERIFY PARAMETERS--very ugly at the moment******/

if (isset($_GET['action']))
{
	if ($_GET['action'] == 'move' || $_GET['action'] == 'copy')
	{
		if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
		    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  &&
		    isset($_GET['parent']) && ctype_digit($_GET['parent']) &&
		    isset($_GET['ptree'])  && ctype_digit($_GET['ptree'])  )
		{
			$validAction = $_GET['action'];
			$validSelect = TRUE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
	elseif ($_GET['action'] == 'insert')
	{
		if (isset($_GET['parent']) && ctype_digit($_GET['parent']) &&
		    isset($_GET['ptree'])  && ctype_digit($_GET['ptree'])  &&
		    isset($_GET['node'])   && strlen($_GET['node']) < 26   )
		{
			$validAction = $_GET['action'];
			$validSelect = TRUE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
	elseif ($_GET['action'] == 'delete')
	{
		if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
		    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  )
		{
			$validAction = $_GET['action'];
			$validSelect = FALSE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
	elseif ($_GET['action'] == 'new')
	{
		if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
		    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  )
		{
			$validAction = $_GET['action'];
			$validSelect = FALSE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
	elseif ($_GET['action'] == 'check')
	{
		if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
		    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  )
		{
			$validAction = $_GET['action'];
			$validSelect = TRUE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
	else
	{
		$validAction = NULL;
		$validSelect = FALSE;
	}
}
else
{
	if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
	    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  )
	{
		$validSelect = TRUE;
		$validAction = NULL;
	}
	else
	{
		$validSelect = FALSE;
		$validAction = NULL;
	}
}

/*****************************INITIALIZE*****************************/

if ($validSelect || $validAction)
{
	for ($i = 0; $i < $numTrees; $i++)
	{
		if (isset($_GET['ntree']) && $_GET['ntree'] == $i)
		{
			$n = $i;
		}
		if (isset($_GET['ptree']) && $_GET['ptree'] == $i)
		{
			$p = $i;
		}
	}

	if (isset($_GET['nodeid']))
	{
		$node = new node($_GET['nodeid'], $trees[$n]);
	}
}
else
{
	$state = STATE_NO_NODE;
	$msg = "Invalid parameters.  Select a node.";
}

switch ($validAction)
{
case 'insert':
	$node       = new node(NULL, $trees[$p]); // make a fake node to access insert method
	$parentNode = new node($_GET['parent'], $trees[$p]);

	// For multi-field inserts separate fields by ";"
	$values = explode(";", $_GET['node']);

	// assemble sortValue based on insert values and orderByFld
	$countOrderBy  = count($trees[$p]->orderByFld);
	$countOther    = count($trees[$p]->otherFlds);
	for ($i = 0; $i < $countOrderBy; $i++)
	{
		for ($j = 0; $j < $countOther; $j++)
		{
			if ($trees[$p]->orderByFld[$i] == $trees[$p]->otherFlds[$j])
			{
				$sortValue .= $values[$j];
				break;
			}
		}
	}

	$startTime = get_microtime();
	$res = $node->insertNode($parentNode, $values, $sortValue);
	$endTime = get_microtime();
	$time = round($endTime - $startTime, MY_ROUND);

	if ($res > 0)
	{
		$msg  = "Insert completed in $time seconds";
		$node = new node($res, $trees[$p]);
		$n = $p;
	}
	else
	{
		$msg = "Insert failed";
		$validSelect = FALSE;
	}
	break;

case 'move':
	$parentNode = new node($_GET['parent'], $trees[$p]);

	$startTime = get_microtime();
	$res = $node->moveSubtree($parentNode);
	$endTime = get_microtime();
	$time = round($endTime - $startTime, MY_ROUND);

	if ($res > 0)
	{
		$msg  = "Move completed in $time seconds";
		if ($n != $p) // need new node if moved to different table
		{
			$node = new node($res, $trees[$p]);
			$n    = $p;
		}
	}
	else
	{
		$msg = "Move failed";
	}
	break;

case 'copy':
	$parentNode = new node($_GET['parent'], $trees[$p]);

	$startTime = get_microtime();
	$res = $node->copySubtree($parentNode);
	$endTime = get_microtime();
	$time = round($endTime - $startTime, MY_ROUND);
	
	if ($res > 0)
	{
		$msg  = "Copy completed in $time seconds";
		$node = new node($res, $trees[$p]);
		$n    = $p;
	}
	else
	{
		$msg = "Copy failed";
	}
	break;

case 'check':
	$startTime = get_microtime();
	$res = $trees[$n]->checkIntegrity(TRUE);
	$endTime = get_microtime();
	$time = round($endTime - $startTime, MY_ROUND);
	
	if ($res)
	{
		$msg = "Passed check in $time seconds";
	}
	else
	{
		$msg = "Failed check";
	}
	break;

case 'delete':
	// get parents before deleting node
	$parents = $node->getParents();

	$startTime = get_microtime();
	$res = $node->deleteSubtree();
	$endTime = get_microtime();
	$time = round($endTime - $startTime, MY_ROUND);

	if ($res > 0)
	{
		$msg = "Delete completed in $time seconds.";
		$state = STATE_NO_NODE;
	}
	else
	{
		$msg = "Delete failed";
	}
	break;

case 'new':
	$state = STATE_NEW_RECORD;
	break;

default:
}


if (($validAction || $validSelect) && !isset($state) )
{
	//YUCK! FIX THIS SOON!
	$state = STATE_VALID;
}

// SELECT
if ($validSelect)
{
	$query = "SELECT ".$node->tree->idFld.", ".$node->tree->displayFld .
		    " FROM ". $node->tree->table .
		    " WHERE ".$node->tree->idFld." = $node->id;";

	$res = mysql_query($query, $db_conn);
	$numRows = mysql_num_rows($res);
	if (!$res)
	{
		$msg = "Query failed<br />$query";
	}
	elseif ($numRows < 1)
	{
		$msg = "Node does not exist:<br />$query";
		$state = STATE_NO_NODE;
	}
	else
	{
		$myrow = mysql_fetch_array($res);
	}
}

// $parents is used to expand selected nodes at page load
// its already set for delete
if ($validAction != 'delete' && isset($node->id))
{
	$parents = $node->getParents();
}
/***************************OUTPUT****************************/

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<style>
body { font-size:11pt; margin:5px; color:#333366; }
table { font-size:11pt; }
.all { width:800px; }

.titlediv
{
  width:800px;
  height:60px;
  margin-top:5px;
}
.bottomdiv { width:800px; text-align:center; }

.tree
{ float:right;
  padding-left:5px;
  padding-top:5px;
  width:400px;
  white-space:nowrap;
}
.lev0 { display:inline; }
.lev1 { display:none; }
.nodeToggle { cursor:pointer; }
.tree a { text-decoration:none; color:blue; }

.formdiv { width:395px; float:left; padding-top:5px;}
.formdiv td { border:2px solid white; padding:3px; }

.box { border: 1px solid #333366; background-color:#99CCFF; }
.box > .bottom { top:1; }

.content
{ margin: 0px 10px;
  padding:10px;
  background-color: #DDEEFF;
  border: 1px solid #333366;
}

.rtop, .bottom { position:relative; left:1px; height:11px; }
.rtop { top: -1px; }

.nw, .ne, .sw, .se { width:11px; height:11px; }
.nw, .sw { float:left; position:relative; left:-2px; }
.ne, .se { float:right; }

.nw { background: url(images/border-nw.png) no-repeat left top; }
.ne { background: url(images/border-ne.png) no-repeat right top; }
.sw { background: url(images/border-sw.png) no-repeat left bottom; }
.se { background: url(images/border-se.png) no-repeat right bottom; }
</style>
<script language='javascript'>
function formAction(action)
{
	document.myform.action.value = action;
	document.myform.submit();
}

function toggleDisplay(list)
{
	location.href = "<?php echo $_SERVER['PHP_SELF']; ?>?nodeid=<?php echo $_GET['nodeid']."&ntree=".$_GET['ntree']; ?>&list=" + list;
}

function expandIt(whichEl, whichButton)
{
	if (document.getElementById(whichEl).style.display == 'inline')
	{
		document.getElementById(whichEl).style.display = 'none';
		document.getElementById(whichButton).src = "images/plus.png";
	}
	else
	{
		document.getElementById(whichEl).style.display = 'inline';
		document.getElementById(whichButton).src = "images/minus.png";
	}
}

isExpanded = false;

function expandAll()
{
	divColl = document.getElementsByTagName("div");
	for (i = 0; i < divColl.length; i++)
	{
		if (divColl[i].className == "lev1")
		{
			divColl[i].style.display = (isExpanded) ? "none" : "inline";
		}
	}
	imgColl = document.getElementsByTagName("img");
	for (i = 0; i < imgColl.length; i++)
	{
		if (imgColl[i].className == "nodeToggle")
		{
			imgColl[i].src = (isExpanded) ? "images/plus.png" : "images/minus.png";
		}
	}
	isExpanded = !isExpanded;
	document.getElementById("exAll").value = (isExpanded) ? "Collapse" : "Expand";
}
<?php
//if term is selected create onLoad function to display list
if (isset($parents))
{
echo "
function expand_list()
{
	var idArray;
	var divID;
	var buttonID;
";

$iarray = $parents;

echo "\tidArray = new Array(";
echo implode(", ", $iarray);
if (count($iarray) < 2)
	echo ", 0";
echo ");\n";
echo "
	for (i = 0; i < idArray.length; i++)
	{
		divID = '".$n."i' + idArray[i];
		buttonID = '".$n."b' + idArray[i];
		document.getElementById(divID).style.display = 'inline';
		document.getElementById(buttonID).src = 'images/minus.png';
	}
}
";
}
?>
function togParents(id)
{
	for (i = 0; i < <?php echo $numTrees; ?>; i++)
	{
		var t = 't' + i;
		var p = 'p' + i;

		if (id == i)
		{
			document.getElementById(t).style.display = 'table-row';
			document.getElementById(p).name = 'parent';
			document.getElementById(p).disabled=false;
		}
		else
		{
			document.getElementById(t).style.display = 'none';
			document.getElementById(p).name = '';
			document.getElementById(p).disabled=true;
		}
	}
}
</script>
</head>
<body onLoad='expand_list()'>
<div class='all'>
<div class='titlediv'><div class='box'>
      <div class='rtop'> 
        <div class='nw'></div>
        <div class='ne'></div>
      </div>
      <div class='content'>
Tree Factory

</div>
      <div class='bottom'> 
        <div class='sw'></div>
        <div class='se'></div>
      </div>
    </div></div>
<?php

/********************************FORM***********************************/

echo "<div class='formdiv'><div class='box'><div class='rtop'><div class='nw'></div><div class='ne'></div></div><div class='content'>\n";

echo "<table><form name='myform'>\n";

if (isset($msg))
{
	echo "<tr><td colspan='2'><b>$msg</b></td></tr>\n";
}

if ($state != STATE_NO_NODE)
{
	echo "<tr><td>Node Tree</td><td>".$node->tree->table."</td></tr>\n";
	echo "<tr><td>Node</td><td><input type='text' name='node' value='".$myrow[$node->tree->displayFld]."'>\n";

	if ($state != STATE_NEW_RECORD)
	{
		echo "<input type='hidden' name='nodeid' value='".$myrow[$node->tree->idFld]."'>\n";
		echo "<input type='hidden' name='ntree' value='".$n."'</td></tr>\n";
	}

	echo "<tr><td>Parent Tree</td>\n<td><select name='ptree'>\n";
	for ($i = 0; $i < $numTrees; $i++)
	{
		echo "<option value='". $i ."' onClick='togParents(\"$i\")'";
		if ($i == $n)
		{
			echo " selected";
		}
		echo ">".  $trees[$i]->table ."</option>\n";
	}
	echo "</select></td></tr>\n";

	for ($i = 0; $i < $numTrees; $i++)
	{
		$treeId = 't'.$i;
		$parId  = 'p'.$i;
		echo "<tr id='$treeId' class='prow'";
		if ($i != $n)
		{
			echo "style='display:none;'";
		}
	
		echo "><td>Parent$i</td><td><select name='";
		if ($i == $n)
		{
			echo "parent";
		}
		echo "' id='$parId'";
		if ($i != $n)
		{
			echo " disabled";
		}
		echo ">\n";

		$query = "SELECT ".$trees[$i]->idFld.", ".$trees[$i]->displayFld .
			    " FROM ". $trees[$i]->table .
			    " ORDER BY ".implode(", ", $trees[$i]->orderByFld).";";

		$res = mysql_query($query, $db_conn);
		while ($optionRow = mysql_fetch_row($res))
		{
			echo "<option value='$optionRow[0]'";
			if ($optionRow[0] == $parents[0]  && $state != STATE_NEW_RECORD)
			{
				 echo " selected";
			}
			echo ">$optionRow[1]</option>\n";
		}
		echo "</select></td></tr>\n";
	}

	// buttons
	echo "<tr><td colspan='2' align='center'>\n";

	if ($state == STATE_NEW_RECORD)
	{
		echo "<input type='hidden' name='action' value='insert'>\n";
		echo "<input type='submit' value='Insert'>\n";
	}
	else
	{
		echo "<input type='hidden' name='action' value=''>\n";
		echo "<input type='button' value ='New' onClick='formAction(\"new\")'>\n";
		echo "<input type='button' value='Move' onClick='formAction(\"move\")'>\n";
		echo "<input type='button' value='Copy' onClick='formAction(\"copy\")'>\n";
		echo "<input type='button' value='Delete' onClick='formAction(\"delete\")'>\n";
		echo "<input type='button' value='Check' onClick='formAction(\"check\")'>\n";
	
		if ($_GET['list'] == 'collapse')
		{
			echo "<input type='button' onClick='expandAll()' value='Expand' id='exAll'>\n";
		}

		$display = $_GET['list'] == 'debug' ? 'collapse' : 'debug' ; 
		echo "<input type='button' onClick='toggleDisplay(\"$display\")' value='Toggle Display' >\n";
		echo "<input type='hidden' name='list' value ='".$_GET['list']."'>\n";
	}

	echo "</td></tr>\n";
}

echo "</form>\n";
echo "</table>\n";
echo "</div><div class='bottom'><div class='sw'></div><div class='se'></div></div></div></div>\n";

/**********************************TREES**********************************/

for ($i = 0; $i < $numTrees; $i++)
{
	//$leftSpace = $i * 400; to be used for horizontal tree layout

	echo "<div class='tree'><div class='box'><div class='rtop'><div class='nw'></div><div class='ne'></div></div><div class='content'>\n";

	echo "Table: ".$trees[$i]->table."<br /><br />";
	//echo "<form><input type='button' onClick='toggleDisplay(\"debug\")' value='Toggle Display' >\n";
	//if ($_GET['list'] == 'collapse')
	//{
	//	echo "<input type='button' onClick='expandAll()' value='Expand' id='exAll'>\n";
	//}
	//echo "</form>";

	$rootId = $trees[$i]->getRootId();

	$rootNode = new node($rootId, $trees[$i]);

	if ($state != STATE_NEW_RECORD && $i == $n)
	{
		$selected = $node->id;
	}
	else
	{
		$selected = NULL;
	}

	if (isset($_GET['list']) && $_GET['list'] == 'debug')
	{
		$startTime = get_microtime();
		display_tree_debug($rootNode, $i, TRUE, $selected);
		$endTime = get_microtime();
	}
	else
	{
		$startTime = get_microtime();
		display_tree_divs($rootNode, $i, FALSE, $selected);
		$endTime = get_microtime();
	}

	$time = round($endTime - $startTime, MY_ROUND);
	echo "<center>Time:  ".$time."</center>\n";
	echo "</div><div class='bottom'><div class='sw'></div><div class='se'></div></div></div></div>\n";
}
/*****************************END-TREES**********************************/

echo "<div class='bottomdiv'><br /><br />";

$allTimeEnd = get_microtime();
$allTime = round($allTimeEnd - $allTimeStart, MY_ROUND);
echo "All Time: ".$allTime;

ob_end_flush();
?>
</div>
</div>
</body>

<br><br><a href="../../index.html" target="_parent">Return to Index</a>
</html>
