<?php
/**************************************************************************
 * Copyright 2004 Jeremy March
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * jeremy_march@comcast.net
 * http://sourceforge.net/projects/tree-factory/
 *
 **************************************************************************/

//error_reporting(E_ALL);
ob_start();

require_once "lib_example1.php";
require_once "TF_nested_sets.php";
$allTimeStart = get_microtime();

/************Config************************/

// Connection Parameters
define('USER',       'treeuser');
define('PASSWORD',   '1234');
define('HOST',       'localhost');
define('DATABASE',   'trees');

define('MY_ROUND',   4);

$db_conn = mysql_pconnect('localhost', 'root', '') or die("Did Not Connect");
mysql_select_db(rototech, $db_conn) or die("Did Not Select Database");

// Tree Parameters
define('TABLE_TYPE',  'myisam');  // e.g. 'myisam', 'innodb', or 'none'
define('DEBUG',       TRUE);

//To add new table add here table fields

// Add new fields  here and go to TF_nested_sets and go to class TF_ns_tree and add the fields there and assign to the function TF_ns_tree.  If table is added no need of changing the class and function.


$fields  = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('node'), 'display'=>'node', 'other'=>array('node'),'lnk'=>'link','compcode'=>'comp_code','searchkey'=>'searchkey','searchkey2'=>'searchkey2','searchkey3'=>'searchkey3','searchkey4'=>'searchkey4','searchkey5'=>'searchkey5','approach'=>'approach');
//$fields1  = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('node'), 'display'=>'node', 'other'=>array('node'),'lnk'=>'link','compcode'=>'comp_code');
//$fields2  = array('id'=>'id', 'left'=>'lft', 'right'=>'rgt', 'orderby'=>array('node'), 'display'=>'node', 'other'=>array('node'),'lnk'=>'link','compcode'=>'comp_code');


//To add table 
$trees   = array();
$trees[] = new TF_ns_tree($db_conn, 'complaint_master', TABLE_TYPE, $fields, DEBUG);
//$trees[] = new TF_ns_tree($db_conn, 'reo_compliant', TABLE_TYPE, $fields1, DEBUG);
//$trees[] = new TF_ns_tree($db_conn, 'ycp_compliant', TABLE_TYPE, $fields2, DEBUG);

/************End-Config************************/

$numTrees = count($trees);

// states for output section
define('STATE_NO_NODE'       , 1);
define('STATE_NEW_RECORD'    , 2);
define('STATE_VALID'         , 3);

define('SPACES_PER_TAB'      , 4);
define('PICS_PER_TAB'        , 40);
/**********************VERIFY PARAMETERS--very ugly at the moment******/

if (isset($_GET['action']))
{
	if ($_GET['action'] == 'insert')
	{
		if (isset($_GET['parent']) && ctype_digit($_GET['parent']) &&
		    isset($_GET['ptree'])  && ctype_digit($_GET['ptree'])  &&
		    isset($_GET['node'])   && strlen($_GET['node']) < 26   )
		{
			$validAction = $_GET['action'];
			$validSelect = TRUE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
	elseif ($_GET['action'] == 'delete')
	{
		if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
		    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  )
		{
			$validAction = $_GET['action'];
			$validSelect = FALSE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
	elseif ($_GET['action'] == 'new')
	{
		if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
		    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  )
		{
			$validAction = $_GET['action'];
			$validSelect = FALSE;
		}
		else
		{
			$validAction = NULL;
			$validSelect = FALSE;
		}
	}
}
else
{
	if (isset($_GET['nodeid']) && ctype_digit($_GET['nodeid']) &&
	    isset($_GET['ntree'])  && ctype_digit($_GET['ntree'])  )
	{
		$validSelect = TRUE;
		$validAction = NULL;
	}
	else
	{
		$validSelect = FALSE;
		$validAction = NULL;
	}
}

/*****************************INITIALIZE*****************************/

if ($validSelect || $validAction)
{
	for ($i = 0; $i < $numTrees; $i++)
	{
		if (isset($_GET['ntree']) && $_GET['ntree'] == $i)
		{
			$n = $i;
		}
		if (isset($_GET['ptree']) && $_GET['ptree'] == $i)
		{
			$p = $i;
		}
	}

	if (isset($_GET['nodeid']))
	{
		$node = new node($_GET['nodeid'], $trees[$n]);
	}
}
else
{
	$state = STATE_NO_NODE;
	$msg = "Invalid parameters.  Select a node.";
}

switch ($validAction)
{
case 'insert':
	$node       = new node(NULL, $trees[$p]); // make a fake node to access insert method
	$parentNode = new node($_GET['parent'], $trees[$p]);
	
	// For multi-field inserts separate fields by ";"
	$values = explode(";", $_GET['node']);
	$linkvalue=$_GET['link'];
	$searchkeyvalue=$_GET['searchkey'];	
	$searchkeyvalue2=$_GET['searchkey2'];	
	$searchkeyvalue3=$_GET['searchkey3'];		
	$searchkeyvalue4=$_GET['searchkey4'];	
	$searchkeyvalue5=$_GET['searchkey5'];			
	$approachvalue=$_GET['approach'];		
	
	//$machcode=substr($trees[$p]->table,0,3);
	$codevalue=$_GET['mach_code'].$_GET['cat1'].$_GET['cat2'];
	

	// assemble sortValue based on insert values and orderByFld
	$countOrderBy  = count($trees[$p]->orderByFld);
	$countOther    = count($trees[$p]->otherFlds);
	for ($i = 0; $i < $countOrderBy; $i++)
	{
		for ($j = 0; $j < $countOther; $j++)
		{
			if ($trees[$p]->orderByFld[$i] == $trees[$p]->otherFlds[$j])
			{
				$sortValue .= $values[$j];
				break;
			}
		}
	}

	$startTime = get_microtime();
	$res = $node->insertNode($parentNode, $values, $linkvalue, $codevalue,$searchkeyvalue,$searchkeyvalue2,$searchkeyvalue3,$searchkeyvalue4,$searchkeyvalue5,$approachvalue, $sortValue);
	$endTime = get_microtime();
	$time = round($endTime - $startTime, MY_ROUND);

	if ($res > 0)
	{
		$msg  = "Insert completed in $time seconds";
		$node = new node($res, $trees[$p]);
		$n = $p;
	}
	else
	{
		$msg = "Insert failed";
		$validSelect = FALSE;
	}
	break;

case 'delete':
	// get parents before deleting node
	$parents = $node->getParents();

	$startTime = get_microtime();
	$res = $node->deleteSubtree();
	$endTime = get_microtime();
	$time = round($endTime - $startTime, MY_ROUND);

	if ($res > 0)
	{
		$msg = "Delete completed in $time seconds.";
		$state = STATE_NO_NODE;
	}
	else
	{
		$msg = "Delete failed";
	}
	break;

case 'new':
	$state = STATE_NEW_RECORD;
	break;

default:
}


if (($validAction || $validSelect) && !isset($state) )
{
	//YUCK! FIX THIS SOON!
	$state = STATE_VALID;
}

// SELECT
if ($validSelect)
{
	$query = "SELECT ".$node->tree->idFld.", ".$node->tree->displayFld .", ".$node->tree->linkFld .", ".$node->tree->searchkeyFld.", ".$node->tree->searchkey2Fld.", ".$node->tree->searchkey3Fld.", ".$node->tree->searchkey4Fld.", ".$node->tree->searchkey5Fld.", ".$node->tree->approachFld.", ".$node->tree->codeFld.
		    " FROM ". $node->tree->table .
		    " WHERE ".$node->tree->idFld." = $node->id;";

	$res = mysql_query($query, $db_conn) or die(mysql_error());
	$numRows = mysql_num_rows($res);
	if (!$res)
	{
		$msg = "Query failed<br />$query";
	}
	elseif ($numRows < 1)
	{
		$msg = "Node does not exist:<br />$query";
		$state = STATE_NO_NODE;
	}
	else
	{
		$myrow = mysql_fetch_array($res);
	}
}

// $parents is used to expand selected nodes at page load
// its already set for delete
if ($validAction != 'delete' && isset($node->id))
{
	$parents = $node->getParents();
}
/***************************OUTPUT****************************/

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<style>
body { font-size:11pt; margin:5px; color:#333366; }
table { font-size:11pt; }
.all { width:800px; }

.titlediv
{
  width:800px;
  height:60px;
  margin-top:5px;
}
.bottomdiv { width:800px; text-align:center; }

.tree
{ float:right;
  padding-left:5px;
  padding-top:5px;
  width:400px;
  white-space:nowrap;
}
.lev0 { display:inline; }
.lev1 { display:none; }
.nodeToggle { cursor:pointer; }
.tree a { text-decoration:none; color:blue; }

.formdiv { width:395px; float:left; padding-top:5px;}
.formdiv td { border:2px solid white; padding:3px; }

.box { border: 1px solid #333366; background-color:#99CCFF; }
.box > .bottom { top:1; }

.content
{ margin: 0px 10px;
  padding:10px;
  background-color: #DDEEFF;
  border: 1px solid #333366;
}

.rtop, .bottom { position:relative; left:1px; height:11px; }
.rtop { top: -1px; }

.nw, .ne, .sw, .se { width:11px; height:11px; }
.nw, .sw { float:left; position:relative; left:-2px; }
.ne, .se { float:right; }

.nw { background: url(images/border-nw.png) no-repeat left top; }
.ne { background: url(images/border-ne.png) no-repeat right top; }
.sw { background: url(images/border-sw.png) no-repeat left bottom; }
.se { background: url(images/border-se.png) no-repeat right bottom; }
</style>
<script language='javascript'>
function formAction(action)
{
	document.myform.action.value = action;
	document.myform.submit();
}

function toggleDisplay(list)
{
	location.href = "<?php echo $_SERVER['PHP_SELF']; ?>?nodeid=<?php echo $_GET['nodeid']."&ntree=".$_GET['ntree']; ?>&list=" + list;
}

function expandIt(whichEl, whichButton)
{
	if (document.getElementById(whichEl).style.display == 'inline')
	{
		document.getElementById(whichEl).style.display = 'none';
		document.getElementById(whichButton).src = "images/plus.png";
	}
	else
	{
		document.getElementById(whichEl).style.display = 'inline';
		document.getElementById(whichButton).src = "images/minus.png";
	}
}

isExpanded = false;

function expandAll()
{
	divColl = document.getElementsByTagName("div");
	for (i = 0; i < divColl.length; i++)
	{
		if (divColl[i].className == "lev1")
		{
			divColl[i].style.display = (isExpanded) ? "none" : "inline";
		}
	}
	imgColl = document.getElementsByTagName("img");
	for (i = 0; i < imgColl.length; i++)
	{
		if (imgColl[i].className == "nodeToggle")
		{
			imgColl[i].src = (isExpanded) ? "images/plus.png" : "images/minus.png";
		}
	}
	isExpanded = !isExpanded;
	document.getElementById("exAll").value = (isExpanded) ? "Collapse" : "Expand";
}
<?php
//if term is selected create onLoad function to display list
if (isset($parents))
{
echo "
function expand_list()
{
	var idArray;
	var divID;
	var buttonID;
";

$iarray = $parents;

echo "\tidArray = new Array(";
echo implode(", ", $iarray);
if (count($iarray) < 2)
	echo ", 0";
echo ");\n";
echo "
	for (i = 0; i < idArray.length; i++)
	{
		divID = '".$n."i' + idArray[i];
		buttonID = '".$n."b' + idArray[i];
		document.getElementById(divID).style.display = 'inline';
		document.getElementById(buttonID).src = 'images/minus.png';
	}
}
";
}
?>
function togParents(id)
{
	for (i = 0; i < <?php echo $numTrees; ?>; i++)
	{
		var t = 't' + i;
		var p = 'p' + i;

		if (id == i)
		{
			document.getElementById(t).style.display = 'table-row';
			document.getElementById(p).name = 'parent';
			document.getElementById(p).disabled=false;
		}
		else
		{
			document.getElementById(t).style.display = 'none';
			document.getElementById(p).name = '';
			document.getElementById(p).disabled=true;
		}
	}
}

function machineCode(mcode)
{
	machcode = "<?php echo $_SERVER['PHP_SELF']; ?>?mach_code=<?php echo $_GET['mach_code'] ?>"

}

</script>
</head>
<body onLoad='expand_list()'>
<div class='all'>
<div class='titlediv'><div class='box'>
      <div class='rtop'> 
        <div class='nw'></div>
        <div class='ne'></div>
      </div>
      <div class='content'>
Complaints

</div>
      <div class='bottom'> </div>
    </div></div>
<?php

/********************************FORM***********************************/

echo "<div class='formdiv'><div class='box'><div class='rtop'><div class='nw'></div><div class='ne'></div></div><div class='content'>\n";

echo "<table><form name='myform'>\n";

if (isset($msg))
{
	echo "<tr><td colspan='2'><b>$msg</b></td></tr>\n";
}

if ($state != STATE_NO_NODE)
{
	echo "<tr><td>Node Tree</td><td>".$node->tree->table."</td></tr>\n";
	echo "<tr><td>Problem</td><td><input type='text' name='node' value='".$myrow[$node->tree->displayFld]."'>\n";

	if ($state != STATE_NEW_RECORD)
	{
		echo "<input type='hidden' name='nodeid' value='".$myrow[$node->tree->idFld]."'>\n";
		echo "<input type='hidden' name='ntree' value='".$n."'</td></tr>\n";
	}

	echo "<tr><td>Parent Tree</td>\n<td><select name='ptree'>\n";
	for ($i = 0; $i < $numTrees; $i++)
	{
		echo "<option value='". $i ."' onClick='togParents(\"$i\")'";
		if ($i == $n)
		{
			echo " selected";
		}
		echo ">".  $trees[$i]->table ."</option>\n";
	}
	echo "</select></td></tr>\n";


	for ($i = 0; $i < $numTrees; $i++)
	{
		$treeId = 't'.$i;
		$parId  = 'p'.$i;
		echo "<tr id='$treeId' class='prow'";
		if ($i != $n)
		{
			echo "style='display:none;'";
		}

		echo "><td>Parent</td><td><select name='";
		if ($i == $n)
		{
			echo "parent";
		}
		echo "' id='$parId'";
		if ($i != $n)
		{
			echo " disabled";
		}
		echo ">\n";

		$query = "SELECT ".$trees[$i]->idFld.", ".$trees[$i]->displayFld .
			    " FROM ". $trees[$i]->table .
			    " ORDER BY ".implode(", ", $trees[$i]->orderByFld).";";
		
		$res = mysql_query($query, $db_conn);
		
		while ($optionRow = mysql_fetch_row($res))
		{
			echo "<option value='$optionRow[0]'";
			if ($optionRow[0] == $parents[0]  && $state != STATE_NEW_RECORD)
			{
				 echo " selected";
			}
			echo ">$optionRow[1]</option>\n";
		}
		echo "</select></td></tr>\n";
	}

		echo "<tr><td>HTML Link</td>";
		echo "<td><input type=text name='link' value='".$myrow[$node->tree->linkFld]."'> (Eg:ycp.htm) </td></tr>";
		
		echo "<tr><td>Search Key 1</td>";
		echo "<td><input type=text name='searchkey' value='".$myrow[$node->tree->searchkeyFld]."'> </td></tr>";		
		
		echo "<tr><td>Search Key 2</td>";
		echo "<td><input type=text name='searchkey2' value='".$myrow[$node->tree->searchkey2Fld]."'> </td></tr>";			
		
		echo "<tr><td>Search Key 3</td>";
		echo "<td><input type=text name='searchkey3' value='".$myrow[$node->tree->searchkey3Fld]."'> </td></tr>";					

		echo "<tr><td>Search Key 4</td>";
		echo "<td><input type=text name='searchkey4' value='".$myrow[$node->tree->searchkey4Fld]."'> </td></tr>";		
		
		echo "<tr><td>Search Key 5</td>";
		echo "<td><input type=text name='searchkey5' value='".$myrow[$node->tree->searchkey5Fld]."'> </td></tr>";				

		echo "<tr><td>Approach </td>";
		echo "<td><input type=text name='approach' value='".$myrow[$node->tree->approachFld]."'> </td></tr>";		

		$query=mysql_query("select machine_code, name from machine order by name");
		echo "<tr><td>Machine</td>\n<td><select name='mach_code'>\n";
		echo "<option value=000 selected> ---";
		while ($row = mysql_fetch_row($query))
		{
			echo "<option value='$row[0]' onChange=''";
			 echo " >$row[1]"." (".$row[0].")";
			 echo "</option>\n";
		}
		echo "</select></td></tr>\n";
		/*
		
		$query=mysql_query("select groupcode, groupname from compliant_grp1 order by groupname");
		echo "<tr><td>Category1</td>\n<td><select name='cat1'>\n";
		echo "<option value=000 selected> ---";
		while ($row = mysql_fetch_row($query))
		{
			echo "<option value='$row[0]'";
			 echo " >$row[1]</option>\n";
		}
		echo "</select></td></tr>\n";


		$query=mysql_query("select category_code, category from compliant_grp2 order by category");
		echo "<tr><td>Category2</td>\n<td><select name='cat2'>\n";
		echo "<option value=000 selected> ---";
		while ($row = mysql_fetch_row($query))
		{
			echo "<option value='$row[0]'";
			 echo " >$row[1]</option>\n";
		}
		echo "</select></td></tr>\n";
		*/


	// buttons
	echo "<tr><td colspan='2' align='center'>\n";

	if ($state == STATE_NEW_RECORD)
	{
		echo "<input type='hidden' name='action' value='insert'>\n";
		echo "<input type='submit' value='Insert'>\n";
	}
	else
	{
		echo "<input type='hidden' name='action' value=''>\n";
		echo "<input type='button' value ='New' onClick='formAction(\"new\")'>\n";
		echo "<input type='button' value='Delete' onClick='formAction(\"delete\")'>\n";
	
		if ($_GET['list'] == 'collapse')
		{
			echo "<input type='button' onClick='expandAll()' value='Expand' id='exAll'>\n";
		}

		$display = $_GET['list'] == 'debug' ? 'collapse' : 'debug' ; 
		echo "<input type='button' onClick='toggleDisplay(\"$display\")' value='Toggle Display' >\n";
		echo "<input type='hidden' name='list' value ='".$_GET['list']."'>\n";
	}

	echo "</td></tr>\n";
}

echo "</form>\n";
echo "</table>\n";
echo "</div><div class='bottom'><div class='sw'></div><div class='se'></div></div></div></div>\n";
/**********************************TREES**********************************/

for ($i = 0; $i < $numTrees; $i++)
{

	echo "<div class='tree'><div class='box'><div class='rtop'><div class='nw'></div><div class='ne'></div></div><div class='content'>\n";
	echo "Table: ".$trees[$i]->table."<br /><br />";
	$rootId = $trees[$i]->getRootId();

	$rootNode = new node($rootId, $trees[$i]);

	if ($state != STATE_NEW_RECORD && $i == $n)
	{
		$selected = $node->id;
	}
	else
	{
		$selected = NULL;
	}

	if (isset($_GET['list']) && $_GET['list'] == 'debug')
	{
		$startTime = get_microtime();
		display_tree_debug($rootNode, $i, TRUE, $selected);
		$endTime = get_microtime();
	}
	else
	{
		$startTime = get_microtime();
		display_tree_divs($rootNode, $i, FALSE, $selected);
		$endTime = get_microtime();
	}

	$time = round($endTime - $startTime, MY_ROUND);
	//echo "<center>Time:  ".$time."</center>\n";
	echo "</div><div class='bottom'><div class='sw'></div><div class='se'></div></div></div></div>\n";
}
/*****************************END-TREES**********************************/

echo "<div class='bottomdiv'><br /><br />";

$allTimeEnd = get_microtime();
$allTime = round($allTimeEnd - $allTimeStart, MY_ROUND);
// echo "All Time: ".$allTime."<br>";
echo "Code = ".$myrow[$node->tree->codeFld];

ob_end_flush();
?>
</div>
</div>
</body>
<left>
<br><br><br><br><br><br><br><br><br><a href="../../../index.html" target="_parent">Return to Index</a></left>
</html>
