<?php

/**
 * @param $id   int
 * @param $tree object
 * @return object or int error code
 */
function factory($id, $tree)
{
	if (is_a($tree, 'TF_ns_tree'))
	{
		return new TF_ns_node($id, $tree);
	}
	elseif (is_a($tree, 'TF_al_tree'))
	{
		return new TF_al_node($id, $tree);
	}
	else
	{
		return 0;
	}
}

/**
 * @return float
 */
function get_microtime()
{
	list($usec, $sec) = explode(" ", microtime());
	return ((float)$usec + (float)$sec);
}

/**
 * @param $rootNode object
 * @param $treeNum  int
 * @param $showRoot bool
 * @param selected  int (optional)
 */
function display_tree_divs($rootNode, $treeNum, $mach,$searchkey, $showRoot = FALSE, $selected = NULL)
{
	$selectFields = array($rootNode->tree->displayFld, $rootNode->tree->linkFld, $rootNode->tree->codeFld, $rootNode->tree->searchkeyFld, $rootNode->tree->idFld);
	$tree = $rootNode->getTreeArray($selectFields, $mach,$searchkey);
	echo "\n";
	
	


	$count = count($tree);

	for ($i = 0; $i <= $count; $i++)
	{

		$picId = $treeNum."b".$tree[$i][$rootNode->tree->idFld];
		$divId = $treeNum."i".$tree[$i][$rootNode->tree->idFld];
		$ccode=$tree[$i][$rootNode->tree->idFld];
		// close appropriate number of divs if necessary

		if ($tree[$i]['close'] > 0)
		{
			$n = $tree[$i - 1]['tab'] - $tree[$i]['close'];
			for ($j = $tree[$i - 1]['tab']; $j > $n; $j--)
			{
				echo str_repeat(" ", ($j - 1) * SPACES_PER_TAB); // SPACES
				echo "</div>\n";
			}
		}
	//	if ($tree[$i]['tab'] != 0 || $showRoot)
	//	{
			echo str_repeat(" ", $tree[$i]['tab'] * SPACES_PER_TAB); // SPACES

			// echo spacer image with appropriate width
			echo "<img src='images/spacer.png' height='2' width='";
			if ($showRoot)
			{
				echo ($tree[$i]['tab'] * PICS_PER_TAB) . "'>";
			}
			else
			{
				echo (($tree[$i]['tab'] - 1) * PICS_PER_TAB) . "'>";
			}

			// echo plus image if has children otherwise 1 more spacer image
			if ($tree[$i]['open'])
			{
				echo "<img src='images/plus.png' id='$picId' class='nodeToggle'";
				echo "onClick='expandIt(\"$divId\",\"$picId\")'>";
			}
			else
			{
				echo "<img src='images/spacer.png' height='2' width='11'>";
			}

			// echo 1 more spacer image then echo node display value
			echo "<img src='images/spacer.png' height='2' width='11'>";

			if(!empty($tree[$i][$rootNode->tree->linkFld]))
			{
//				echo "<a href=javascript:window.open('../".$tree[$i][$rootNode->tree->linkFld]."','win','directories=0,top=0,left=0,height=600,scrollbars=yes')";
				echo "<a href=../".$tree[$i][$rootNode->tree->linkFld];
			}
			else
			{
				echo "<a href=main-page.htm";
			}
			
			if ($tree[$i][$rootNode->tree->idFld] == $selected)
			{
				echo " style='color:red;'";
				
			}
			echo " target = mainFrame onClick='updatetemp(\"$ccode\")';>";
			echo $tree[$i][$rootNode->tree->displayFld]."</a><br />\n";
		//}

		// open div if just echoed node has children
		if ($tree[$i]['open'])
		{
			echo str_repeat(" ", $tree[$i]['tab'] * SPACES_PER_TAB); // SPACES
			if ($tree[$i]['tab'] == 0 && !$showRoot)
			{
				echo "<div class='lev0' id='$divId'>\n";
			}
			else
			{
				echo "<div class='lev1' id='$divId'>\n";
			}
		}
		
	}
//		 mysql_query("insert into sieger.temp values('man')") or die(mysql_error());
	// close last divs
	for ($j = $tree[$i - 1]['tab']; $j > 0 ; $j--)
	{
		echo str_repeat(" ", ($j - 1) * SPACES_PER_TAB);
		echo "</div>\n";
	}
}

?>
<script language="javascript">
function updatetemp(ccode)
{
	
	var ccode;

	
//	alert(ccode);
  //  document.cookie = "vinod"+"="+ccode+expires+"; path=/";
//	alert(document.cookie);
 }


</script>



<?




/*
function updatetemp($ccode)
{
	echo "Code ".$ccode;
	$query="update temp set code = $ccode";
	mysql_query($query) or die(mysql_error());
}
*/
/**
 * @param $rootNode object
 * @param $treeNum  int
 * @param $showRoot bool
 * @param selected  int (optional)
 */
function display_tree_debug($rootNode, $treeNum, $showRoot = FALSE, $selected = NULL)
{
	$selectFields = array($rootNode->tree->displayFld, $rootNode->tree->idFld, 
					  $rootNode->tree->leftFld, $rootNode->tree->rightFld);

	$tree = $rootNode->getTreeArray($selectFields);

	echo "<div class='debug'>";

	$count = count($tree);

	for ($i = 0; $i < $count; $i++)
	{
		if ($tree[$i]['tab'] != 0 || $showRoot)
		{
			echo "<img src='images/spacer.png' height='1' width='";
			if ($showRoot)
			{
				echo ($tree[$i]['tab'] * PICS_PER_TAB) . "'>";
			}
			else
			{
				echo (($tree[$i]['tab'] - 1) * PICS_PER_TAB) . "'>";
			}
			echo $tree[$i][$rootNode->tree->leftFld]."--<a href='".$_SERVER['PHP_SELF']."?nodeid=";
			echo $tree[$i][$rootNode->tree->idFld]."&list=debug&ntree=".$treeNum."'";

			if ($tree[$i][$rootNode->tree->idFld] == $selected)
			{
				echo " style='color:red;'";
			}
			else
			{
				echo " style='color:blue;'";
			}
			echo ">";
			echo $tree[$i][$rootNode->tree->displayFld]."</a>--".$tree[$i][$rootNode->tree->rightFld]."<br />\n";
		}
	}
	echo "</div>";
}
?>
